static void mean(String daten) {
    DataInputStream dis = null;
    try {
        dis = new DataInputStream(new FileInputStream(daten));
        double sum = 0.0;
        int n = 0;
        while (dis.available() > 0) {
            n++;
            sum += dis.readDouble();
        }
        IO.println("Mittelwert zur Datei " + daten + ":  " + sum / n);
    } catch (IOException ioe) {
        ioe.printStackTrace();
    } finally {
        if (dis != null)
            try {
                dis.close();
            } catch (IOException ioc) {
                ioc.printStackTrace();
            }
    }
}

static void createData(String daten) {
    DataOutputStream dos = null;
    try {
        dos = new DataOutputStream(new FileOutputStream(daten));
        Random ran = new Random();
        for (int i = 1; i <= 100; i++)
            dos.writeDouble(ran.nextDouble());
    } catch (IOException ioe) {
        ioe.printStackTrace();
    } finally {
        if (dos != null)
            try {
                dos.close();
            } catch (IOException ioc) {
                ioc.printStackTrace();
            }
    }
}

void main() {
    createData("eingabe.dat");
    mean("eingabe.dat");
}
